/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1735;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ContentsFilterLogicContainer
extends FilterLogicContainer<ContentsFilterLogic> {
    private static final String DATA_CONTENTS_FILTER_TYPE = "contentsFilterType";

    public ContentsFilterLogicContainer(Supplier<ContentsFilterLogic> filterLogic, IServerUpdater serverUpdater, Consumer<class_1735> addSlot) {
        super(filterLogic, serverUpdater, addSlot);
        if (this.getFilterType() == ContentsFilterType.STORAGE) {
            this.getFilterSlots().forEach(s -> s.setEnabled(false));
        }
    }

    public void setFilterType(ContentsFilterType depositFilterType) {
        ((ContentsFilterLogic)this.filterLogic.get()).setDepositFilterType(depositFilterType);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new class_2487(), DATA_CONTENTS_FILTER_TYPE, depositFilterType));
    }

    @Override
    public boolean handleMessage(class_2487 data) {
        if (this.isDifferentFilterLogicsData(data)) {
            return false;
        }
        if (data.method_10545(DATA_CONTENTS_FILTER_TYPE)) {
            this.setFilterType(ContentsFilterType.fromName(data.method_10558(DATA_CONTENTS_FILTER_TYPE)));
        }
        return super.handleMessage(data);
    }

    public ContentsFilterType getFilterType() {
        return ((ContentsFilterLogic)this.filterLogic.get()).getFilterType();
    }
}

